/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.customRecipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.stream.Stream;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.items.KleinStar;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.utils.Constants;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public class FullKleinStarIngredient
extends Ingredient {
    public static final IIngredientSerializer<FullKleinStarIngredient> SERIALIZER = new IIngredientSerializer<FullKleinStarIngredient>(){

        @NotNull
        public FullKleinStarIngredient parse(@NotNull FriendlyByteBuf buffer) {
            return new FullKleinStarIngredient((KleinStar.EnumKleinTier)buffer.m_130066_(KleinStar.EnumKleinTier.class));
        }

        @NotNull
        public FullKleinStarIngredient parse(@NotNull JsonObject json) {
            int tier = GsonHelper.m_13927_((JsonObject)json, (String)"tier");
            KleinStar.EnumKleinTier[] tiers = KleinStar.EnumKleinTier.values();
            if (tier < 0 || tier >= tiers.length) {
                throw new JsonParseException("Invalid klein star tier");
            }
            return new FullKleinStarIngredient(tiers[tier]);
        }

        public void write(@NotNull FriendlyByteBuf buffer, @NotNull FullKleinStarIngredient ingredient) {
            buffer.m_130068_((Enum)((KleinStar)ingredient.star.m_41720_()).tier);
        }
    };
    private final ItemStack star;

    private static ItemStack getFullStar(KleinStar.EnumKleinTier tier) {
        ItemStack star = new ItemStack((ItemLike)PEItems.getStar(tier));
        ItemPE.setEmc(star, Constants.MAX_KLEIN_EMC[tier.ordinal()]);
        return star;
    }

    public FullKleinStarIngredient(KleinStar.EnumKleinTier tier) {
        this(FullKleinStarIngredient.getFullStar(tier));
    }

    private FullKleinStarIngredient(ItemStack star) {
        super(Stream.of(new Ingredient.ItemValue(star)));
        this.star = star;
    }

    public boolean test(@Nullable ItemStack input) {
        return input != null && !input.m_41619_() && ItemStack.m_41728_((ItemStack)input, (ItemStack)this.star);
    }

    public boolean isSimple() {
        return false;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID(SERIALIZER).toString());
        json.addProperty("tier", (Number)((KleinStar)this.star.m_41720_()).tier.ordinal());
        return json;
    }
}

